//
//	MBsysTran - Release 8.1
//
//	Copyright 
//	Universite catholique de Louvain (UCLouvain) 
//	Mechatronic, Electrical Energy, and Dynamic systems (MEED Division) 
//	2, Place du Levant
//	1348 Louvain-la-Neuve 
//	Belgium 
//
//	http://www.robotran.be 
//
//	==> Generation Date: Wed Sep 15 15:32:03 2021
//
//	==> Project name: five_point_suspension_python
//
//	==> Number of joints: 16
//
//	==> Function: F1 - Recursive Direct Dynamics of tree-like MBS
//
//	==> Git hash: e4323cc50f813318b5c64b3b53763c941a34ce32
//

#include <math.h> 

#include "mbs_data.h"

// #include "mbs_dirdyna_xml_five_point_suspension_python.h"  // future development
// #include "mbs_dirdyna_hard_five_point_suspension_python.h" // future development
 
void mbs_dirdyna(double **M, double *c,
MbsData *s, double tsim)
{
#include "mbs_dirdyna_five_point_suspension_python.h"

double *q, *qd;
double *g, *m;
double **l, **In, **dpt, **frc, **trq;

q = s->q;
qd = s->qd;

dpt = s->dpt;
l  = s->l;

m = s->m;
In = s->In;

frc = s->frc;
trq = s->trq;
g = s->g;
 
// Trigonometric functions

S2 = sin(q[2]);
C2 = cos(q[2]);
S3 = sin(q[3]);
C3 = cos(q[3]);
S4 = sin(q[4]);
C4 = cos(q[4]);
S5 = sin(q[5]);
C5 = cos(q[5]);
S6 = sin(q[6]);
C6 = cos(q[6]);
S7 = sin(q[7]);
C7 = cos(q[7]);
S8 = sin(q[8]);
C8 = cos(q[8]);
S9 = sin(q[9]);
C9 = cos(q[9]);
S10 = sin(q[10]);
C10 = cos(q[10]);
S11 = sin(q[11]);
C11 = cos(q[11]);
S12 = sin(q[12]);
C12 = cos(q[12]);
S13 = sin(q[13]);
C13 = cos(q[13]);
S14 = sin(q[14]);
C14 = cos(q[14]);
S15 = sin(q[15]);
C15 = cos(q[15]);
 
// Forward Kinematics

AF22 = -g[3]*S2;
AF32 = -g[3]*C2;
OM13 = qd[2]*C3;
OM23 = -qd[2]*S3;
OA13 = -qd[2]*qd[3]*S3;
BS23 = OM13*OM23;
BS53 = -qd[3]*qd[3]-OM13*OM13;
BS63 = qd[3]*OM23;
BEF83 = BS63+OA13;
AF13 = AF22*S3;
AF23 = AF22*C3;
AM13_1 = S2*S3;
AM23_1 = S2*C3;
AF24 = -g[3]*S4;
AF34 = -g[3]*C4;
OM15 = qd[4]*C5;
OM25 = -qd[4]*S5;
OA15 = -qd[4]*qd[5]*S5;
BS25 = OM15*OM25;
BS55 = -qd[5]*qd[5]-OM15*OM15;
BS65 = qd[5]*OM25;
BEF85 = BS65+OA15;
AF15 = AF24*S5;
AF25 = AF24*C5;
AM15_1 = S4*S5;
AM25_1 = S4*C5;
AF26 = -g[3]*S6;
AF36 = -g[3]*C6;
OM17 = qd[6]*C7;
OM27 = -qd[6]*S7;
OA17 = -qd[6]*qd[7]*S7;
BS27 = OM17*OM27;
BS57 = -qd[7]*qd[7]-OM17*OM17;
BS67 = qd[7]*OM27;
BEF87 = BS67+OA17;
AF17 = AF26*S7;
AF27 = AF26*C7;
AM17_1 = S6*S7;
AM27_1 = S6*C7;
AF28 = -g[3]*S8;
AF38 = -g[3]*C8;
OM19 = qd[8]*C9;
OM29 = -qd[8]*S9;
OA19 = -qd[8]*qd[9]*S9;
BS29 = OM19*OM29;
BS59 = -qd[9]*qd[9]-OM19*OM19;
BS69 = qd[9]*OM29;
BEF89 = BS69+OA19;
AF19 = AF28*S9;
AF29 = AF28*C9;
AM19_1 = S8*S9;
AM29_1 = S8*C9;
AF210 = -g[3]*S10;
AF310 = -g[3]*C10;
OM111 = qd[10]*C11;
OM211 = -qd[10]*S11;
OA111 = -qd[10]*qd[11]*S11;
OA211 = -qd[10]*qd[11]*C11;
BS211 = OM111*OM211;
BS511 = -qd[11]*qd[11]-OM111*OM111;
BS611 = qd[11]*OM211;
BEF811 = BS611+OA111;
AF111 = AF210*S11;
AF211 = AF210*C11;
AM111_1 = S10*S11;
AM211_1 = S10*C11;
OM112 = qd[12]+OM111;
OM212 = qd[11]*S12+OM211*C12;
OM312 = qd[11]*C12-OM211*S12;
OA212 = -qd[12]*OM211*S12+C12*(OA211+qd[11]*qd[12]);
OA312 = -qd[12]*OM211*C12-S12*(OA211+qd[11]*qd[12]);
AF112 = AF111+BS211*dpt[2][12];
AF212 = C12*(AF211+BS511*dpt[2][12])+S12*(AF310+BEF811*dpt[2][12]);
AF312 = C12*(AF310+BEF811*dpt[2][12])-S12*(AF211+BS511*dpt[2][12]);
AM212_1 = AM211_1*C12+C10*S12;
AM312_1 = -AM211_1*S12+C10*C12;
OB212_10 = -S11*C12;
OB312_10 = S11*S12;
AM212_10 = dpt[2][12]*C11*S12;
AM312_10 = dpt[2][12]*C11*C12;
OM113 = OM112*C13-OM312*S13;
OM213 = qd[13]+OM212;
OM313 = OM112*S13+OM312*C13;
OA113 = C13*(OA111-qd[13]*OM312)-S13*(OA312+qd[13]*OM112);
OA313 = C13*(OA312+qd[13]*OM112)+S13*(OA111-qd[13]*OM312);
AF113 = AF112*C13-AF312*S13;
AF313 = AF112*S13+AF312*C13;
AM113_1 = AM111_1*C13-AM312_1*S13;
AM313_1 = AM111_1*S13+AM312_1*C13;
OB113_10 = -OB312_10*S13+C11*C13;
OB313_10 = OB312_10*C13+C11*S13;
AM113_10 = -AM312_10*S13;
AM313_10 = AM312_10*C13;
OB113_11 = -C12*S13;
OB313_11 = C12*C13;
AM113_11 = -dpt[2][12]*C13;
AM313_11 = -dpt[2][12]*S13;
OM114 = OM113*C14+OM213*S14;
OM214 = -OM113*S14+OM213*C14;
OM314 = qd[14]+OM313;
OA114 = C14*(OA113+qd[14]*OM213)+S14*(OA212-qd[14]*OM113);
OA214 = C14*(OA212-qd[14]*OM113)-S14*(OA113+qd[14]*OM213);
BS114 = -OM214*OM214-OM314*OM314;
BS214 = OM114*OM214;
BS314 = OM114*OM314;
BS514 = -OM114*OM114-OM314*OM314;
BS614 = OM214*OM314;
BS914 = -OM114*OM114-OM214*OM214;
BEF214 = BS214-OA313;
BEF314 = BS314+OA214;
BEF414 = BS214+OA313;
BEF614 = BS614-OA114;
BEF714 = BS314-OA214;
BEF814 = BS614+OA114;
AF114 = AF113*C14+AF212*S14;
AF214 = -AF113*S14+AF212*C14;
AM114_1 = AM113_1*C14+AM212_1*S14;
AM214_1 = -AM113_1*S14+AM212_1*C14;
OB114_10 = OB113_10*C14+OB212_10*S14;
OB214_10 = -OB113_10*S14+OB212_10*C14;
AM114_10 = AM113_10*C14+AM212_10*S14;
AM214_10 = -AM113_10*S14+AM212_10*C14;
OB114_11 = OB113_11*C14+S12*S14;
OB214_11 = -OB113_11*S14+S12*C14;
AM114_11 = AM113_11*C14;
AM214_11 = -AM113_11*S14;
OB114_12 = C13*C14;
OB214_12 = -C13*S14;
OM115 = OM114*C15-OM314*S15;
OM215 = qd[15]+OM214;
OM315 = OM114*S15+OM314*C15;
OA115 = C15*(OA114-qd[15]*OM314)-S15*(OA313+qd[15]*OM114);
OA315 = C15*(OA313+qd[15]*OM114)+S15*(OA114-qd[15]*OM314);
AF115 = C15*(AF114+BEF214*dpt[2][14]+BEF314*dpt[3][14]+BS114*dpt[1][14])-S15*(AF313+BEF714*dpt[1][14]+BEF814*
 dpt[2][14]+BS914*dpt[3][14]);
AF215 = AF214+BEF414*dpt[1][14]+BEF614*dpt[3][14]+BS514*dpt[2][14];
AF315 = C15*(AF313+BEF714*dpt[1][14]+BEF814*dpt[2][14]+BS914*dpt[3][14])+S15*(AF114+BEF214*dpt[2][14]+BEF314*
 dpt[3][14]+BS114*dpt[1][14]);
AM115_1 = AM114_1*C15-AM313_1*S15;
AM315_1 = AM114_1*S15+AM313_1*C15;
OB115_10 = OB114_10*C15-OB313_10*S15;
OB315_10 = OB114_10*S15+OB313_10*C15;
AM115_10 = C15*(AM114_10+OB214_10*dpt[3][14]-OB313_10*dpt[2][14])-S15*(AM313_10+OB114_10*dpt[2][14]-OB214_10*
 dpt[1][14]);
AM215_10 = AM214_10-OB114_10*dpt[3][14]+OB313_10*dpt[1][14];
AM315_10 = C15*(AM313_10+OB114_10*dpt[2][14]-OB214_10*dpt[1][14])+S15*(AM114_10+OB214_10*dpt[3][14]-OB313_10*
 dpt[2][14]);
OB115_11 = OB114_11*C15-OB313_11*S15;
OB315_11 = OB114_11*S15+OB313_11*C15;
AM115_11 = C15*(AM114_11+OB214_11*dpt[3][14]-OB313_11*dpt[2][14])-S15*(AM313_11+OB114_11*dpt[2][14]-OB214_11*
 dpt[1][14]);
AM215_11 = AM214_11-OB114_11*dpt[3][14]+OB313_11*dpt[1][14];
AM315_11 = C15*(AM313_11+OB114_11*dpt[2][14]-OB214_11*dpt[1][14])+S15*(AM114_11+OB214_11*dpt[3][14]-OB313_11*
 dpt[2][14]);
OB115_12 = OB114_12*C15-S13*S15;
OB315_12 = OB114_12*S15+S13*C15;
AM115_12 = C15*(OB214_12*dpt[3][14]-dpt[2][14]*S13)-S15*(OB114_12*dpt[2][14]-OB214_12*dpt[1][14]);
AM215_12 = -OB114_12*dpt[3][14]+dpt[1][14]*S13;
AM315_12 = C15*(OB114_12*dpt[2][14]-OB214_12*dpt[1][14])+S15*(OB214_12*dpt[3][14]-dpt[2][14]*S13);
OB115_13 = S14*C15;
OB315_13 = S14*S15;
AM115_13 = dpt[3][14]*C14*C15-S15*(-dpt[1][14]*C14+dpt[2][14]*S14);
AM215_13 = -dpt[3][14]*S14;
AM315_13 = dpt[3][14]*C14*S15+C15*(-dpt[1][14]*C14+dpt[2][14]*S14);
AM115_14 = -dpt[2][14]*C15;
AM315_14 = -dpt[2][14]*S15;
 
// Backward Dynamics

FA115 = -frc[1][15]+m[15]*AF115;
FA215 = -frc[2][15]+m[15]*AF215;
FA315 = -frc[3][15]+m[15]*AF315;
CF115 = -trq[1][15]+In[1][15]*OA115-In[5][15]*OM215*OM315+In[9][15]*OM215*OM315;
CF215 = -trq[2][15]+In[1][15]*OM115*OM315+In[5][15]*OA214-In[9][15]*OM115*OM315;
CF315 = -trq[3][15]-In[1][15]*OM115*OM215+In[5][15]*OM115*OM215+In[9][15]*OA315;
FB115_1 = m[15]*AM115_1;
FB215_1 = m[15]*AM214_1;
FB315_1 = m[15]*AM315_1;
FB115_10 = m[15]*AM115_10;
FB215_10 = m[15]*AM215_10;
FB315_10 = m[15]*AM315_10;
CM115_10 = In[1][15]*OB115_10;
CM215_10 = In[5][15]*OB214_10;
CM315_10 = In[9][15]*OB315_10;
FB115_11 = m[15]*AM115_11;
FB215_11 = m[15]*AM215_11;
FB315_11 = m[15]*AM315_11;
CM115_11 = In[1][15]*OB115_11;
CM215_11 = In[5][15]*OB214_11;
CM315_11 = In[9][15]*OB315_11;
FB115_12 = m[15]*AM115_12;
FB215_12 = m[15]*AM215_12;
FB315_12 = m[15]*AM315_12;
CM115_12 = In[1][15]*OB115_12;
CM215_12 = In[5][15]*OB214_12;
CM315_12 = In[9][15]*OB315_12;
FB115_13 = m[15]*AM115_13;
FB215_13 = m[15]*AM215_13;
FB315_13 = m[15]*AM315_13;
CM115_13 = In[1][15]*OB115_13;
CM215_13 = In[5][15]*C14;
CM315_13 = In[9][15]*OB315_13;
FB115_14 = m[15]*AM115_14;
FB215_14 = m[15]*dpt[1][14];
FB315_14 = m[15]*AM315_14;
CM115_14 = -In[1][15]*S15;
CM315_14 = In[9][15]*C15;
FA114 = -frc[1][14]+m[14]*(AF114+BEF214*l[2][14]+BEF314*l[3][14]+BS114*l[1][14]);
FA214 = -frc[2][14]+m[14]*(AF214+BEF414*l[1][14]+BEF614*l[3][14]+BS514*l[2][14]);
FA314 = -frc[3][14]+m[14]*(AF313+BEF714*l[1][14]+BEF814*l[2][14]+BS914*l[3][14]);
FF114 = FA114+FA115*C15+FA315*S15;
FF214 = FA214+FA215;
FF314 = FA314-FA115*S15+FA315*C15;
CF114 = -trq[1][14]+In[1][14]*OA114+In[2][14]*OA214+In[3][14]*OA313+CF115*C15+CF315*S15-FA214*l[3][14]-FA215*
 dpt[3][14]+FA314*l[2][14]+OM214*(In[3][14]*OM114+In[6][14]*OM214+In[9][14]*OM314)-OM314*(In[2][14]*OM114+In[5][14]*OM214+
 In[6][14]*OM314)+dpt[2][14]*(-FA115*S15+FA315*C15);
CF214 = -trq[2][14]+CF215+In[2][14]*OA114+In[5][14]*OA214+In[6][14]*OA313+FA114*l[3][14]-FA314*l[1][14]-OM114*(
 In[3][14]*OM114+In[6][14]*OM214+In[9][14]*OM314)+OM314*(In[1][14]*OM114+In[2][14]*OM214+In[3][14]*OM314)-dpt[1][14]*(-FA115*
 S15+FA315*C15)+dpt[3][14]*(FA115*C15+FA315*S15);
CF314 = -trq[3][14]+In[3][14]*OA114+In[6][14]*OA214+In[9][14]*OA313-CF115*S15+CF315*C15-FA114*l[2][14]+FA214*l[1][14]+
 FA215*dpt[1][14]+OM114*(In[2][14]*OM114+In[5][14]*OM214+In[6][14]*OM314)-OM214*(In[1][14]*OM114+In[2][14]*OM214+In[3][14]*
 OM314)-dpt[2][14]*(FA115*C15+FA315*S15);
FB114_1 = m[14]*AM114_1;
FB214_1 = m[14]*AM214_1;
FB314_1 = m[14]*AM313_1;
FM114_1 = FB114_1+FB115_1*C15+FB315_1*S15;
FM214_1 = FB214_1+FB215_1;
FM314_1 = FB314_1-FB115_1*S15+FB315_1*C15;
CM114_1 = -FB214_1*l[3][14]-FB215_1*dpt[3][14]+FB314_1*l[2][14]+dpt[2][14]*(-FB115_1*S15+FB315_1*C15);
CM214_1 = FB114_1*l[3][14]-FB314_1*l[1][14]-dpt[1][14]*(-FB115_1*S15+FB315_1*C15)+dpt[3][14]*(FB115_1*C15+FB315_1*S15);
CM314_1 = -FB114_1*l[2][14]+FB214_1*l[1][14]+FB215_1*dpt[1][14]-dpt[2][14]*(FB115_1*C15+FB315_1*S15);
FB114_10 = m[14]*(AM114_10+OB214_10*l[3][14]-OB313_10*l[2][14]);
FB214_10 = m[14]*(AM214_10-OB114_10*l[3][14]+OB313_10*l[1][14]);
FB314_10 = m[14]*(AM313_10+OB114_10*l[2][14]-OB214_10*l[1][14]);
FM114_10 = FB114_10+FB115_10*C15+FB315_10*S15;
FM214_10 = FB214_10+FB215_10;
FM314_10 = FB314_10-FB115_10*S15+FB315_10*C15;
CM114_10 = In[1][14]*OB114_10+In[2][14]*OB214_10+In[3][14]*OB313_10+CM115_10*C15+CM315_10*S15-FB214_10*l[3][14]-
 FB215_10*dpt[3][14]+FB314_10*l[2][14]+dpt[2][14]*(-FB115_10*S15+FB315_10*C15);
CM214_10 = CM215_10+In[2][14]*OB114_10+In[5][14]*OB214_10+In[6][14]*OB313_10+FB114_10*l[3][14]-FB314_10*l[1][14]-
 dpt[1][14]*(-FB115_10*S15+FB315_10*C15)+dpt[3][14]*(FB115_10*C15+FB315_10*S15);
CM314_10 = In[3][14]*OB114_10+In[6][14]*OB214_10+In[9][14]*OB313_10-CM115_10*S15+CM315_10*C15-FB114_10*l[2][14]+
 FB214_10*l[1][14]+FB215_10*dpt[1][14]-dpt[2][14]*(FB115_10*C15+FB315_10*S15);
FB114_11 = m[14]*(AM114_11+OB214_11*l[3][14]-OB313_11*l[2][14]);
FB214_11 = m[14]*(AM214_11-OB114_11*l[3][14]+OB313_11*l[1][14]);
FB314_11 = m[14]*(AM313_11+OB114_11*l[2][14]-OB214_11*l[1][14]);
FM114_11 = FB114_11+FB115_11*C15+FB315_11*S15;
FM214_11 = FB214_11+FB215_11;
FM314_11 = FB314_11-FB115_11*S15+FB315_11*C15;
CM114_11 = In[1][14]*OB114_11+In[2][14]*OB214_11+In[3][14]*OB313_11+CM115_11*C15+CM315_11*S15-FB214_11*l[3][14]-
 FB215_11*dpt[3][14]+FB314_11*l[2][14]+dpt[2][14]*(-FB115_11*S15+FB315_11*C15);
CM214_11 = CM215_11+In[2][14]*OB114_11+In[5][14]*OB214_11+In[6][14]*OB313_11+FB114_11*l[3][14]-FB314_11*l[1][14]-
 dpt[1][14]*(-FB115_11*S15+FB315_11*C15)+dpt[3][14]*(FB115_11*C15+FB315_11*S15);
CM314_11 = In[3][14]*OB114_11+In[6][14]*OB214_11+In[9][14]*OB313_11-CM115_11*S15+CM315_11*C15-FB114_11*l[2][14]+
 FB214_11*l[1][14]+FB215_11*dpt[1][14]-dpt[2][14]*(FB115_11*C15+FB315_11*S15);
FB114_12 = m[14]*(OB214_12*l[3][14]-l[2][14]*S13);
FB214_12 = m[14]*(-OB114_12*l[3][14]+l[1][14]*S13);
FB314_12 = m[14]*(OB114_12*l[2][14]-OB214_12*l[1][14]);
CM114_12 = In[1][14]*OB114_12+In[2][14]*OB214_12+In[3][14]*S13+CM115_12*C15+CM315_12*S15-FB214_12*l[3][14]-FB215_12*
 dpt[3][14]+FB314_12*l[2][14]+dpt[2][14]*(-FB115_12*S15+FB315_12*C15);
CM214_12 = CM215_12+In[2][14]*OB114_12+In[5][14]*OB214_12+In[6][14]*S13+FB114_12*l[3][14]-FB314_12*l[1][14]-dpt[1][14]
 *(-FB115_12*S15+FB315_12*C15)+dpt[3][14]*(FB115_12*C15+FB315_12*S15);
CM314_12 = In[3][14]*OB114_12+In[6][14]*OB214_12+In[9][14]*S13-CM115_12*S15+CM315_12*C15-FB114_12*l[2][14]+FB214_12*
 l[1][14]+FB215_12*dpt[1][14]-dpt[2][14]*(FB115_12*C15+FB315_12*S15);
FB114_13 = m[14]*l[3][14]*C14;
FB214_13 = -m[14]*l[3][14]*S14;
FB314_13 = m[14]*(-l[1][14]*C14+l[2][14]*S14);
CM114_13 = In[1][14]*S14+In[2][14]*C14+CM115_13*C15+CM315_13*S15-FB214_13*l[3][14]-FB215_13*dpt[3][14]+FB314_13*
 l[2][14]+dpt[2][14]*(-FB115_13*S15+FB315_13*C15);
CM214_13 = CM215_13+In[2][14]*S14+In[5][14]*C14+FB114_13*l[3][14]-FB314_13*l[1][14]-dpt[1][14]*(-FB115_13*S15+FB315_13
 *C15)+dpt[3][14]*(FB115_13*C15+FB315_13*S15);
CM314_13 = In[3][14]*S14+In[6][14]*C14-CM115_13*S15+CM315_13*C15-FB114_13*l[2][14]+FB214_13*l[1][14]+FB215_13*
 dpt[1][14]-dpt[2][14]*(FB115_13*C15+FB315_13*S15);
FB114_14 = -m[14]*l[2][14];
FB214_14 = m[14]*l[1][14];
CM314_14 = In[9][14]-CM115_14*S15+CM315_14*C15-FB114_14*l[2][14]+FB214_14*l[1][14]+FB215_14*dpt[1][14]-dpt[2][14]*(
 FB115_14*C15+FB315_14*S15);
FF113 = FF114*C14-FF214*S14;
FF213 = FF114*S14+FF214*C14;
CF113 = CF114*C14-CF214*S14;
CF213 = CF114*S14+CF214*C14;
FM113_1 = FM114_1*C14-FM214_1*S14;
FM213_1 = FM114_1*S14+FM214_1*C14;
CM113_1 = CM114_1*C14-CM214_1*S14;
CM213_1 = CM114_1*S14+CM214_1*C14;
FM113_10 = FM114_10*C14-FM214_10*S14;
FM213_10 = FM114_10*S14+FM214_10*C14;
CM113_10 = CM114_10*C14-CM214_10*S14;
CM213_10 = CM114_10*S14+CM214_10*C14;
FM113_11 = FM114_11*C14-FM214_11*S14;
CM113_11 = CM114_11*C14-CM214_11*S14;
CM213_11 = CM114_11*S14+CM214_11*C14;
CM113_12 = CM114_12*C14-CM214_12*S14;
CM213_12 = CM114_12*S14+CM214_12*C14;
CM213_13 = CM114_13*S14+CM214_13*C14;
FF112 = FF113*C13+FF314*S13;
FF312 = -FF113*S13+FF314*C13;
CF112 = CF113*C13+CF314*S13;
CF312 = -CF113*S13+CF314*C13;
FM112_1 = FM113_1*C13+FM314_1*S13;
FM312_1 = -FM113_1*S13+FM314_1*C13;
CM112_1 = CM113_1*C13+CM314_1*S13;
CM312_1 = -CM113_1*S13+CM314_1*C13;
FM112_10 = FM113_10*C13+FM314_10*S13;
FM312_10 = -FM113_10*S13+FM314_10*C13;
CM112_10 = CM113_10*C13+CM314_10*S13;
CM312_10 = -CM113_10*S13+CM314_10*C13;
FM112_11 = FM113_11*C13+FM314_11*S13;
CM112_11 = CM113_11*C13+CM314_11*S13;
CM312_11 = -CM113_11*S13+CM314_11*C13;
CM112_12 = CM113_12*C13+CM314_12*S13;
FA111 = -frc[1][11]+m[11]*(AF111+BS211*l[2][11]);
FA211 = -frc[2][11]+m[11]*(AF211+BS511*l[2][11]);
FA311 = -frc[3][11]+m[11]*(AF310+BEF811*l[2][11]);
FF111 = FA111+FF112;
FF211 = FA211+FF213*C12-FF312*S12;
FF311 = FA311+FF213*S12+FF312*C12;
CF111 = -trq[1][11]+CF112+FA311*l[2][11]+dpt[2][12]*(FF213*S12+FF312*C12);
CF211 = -trq[2][11]+CF213*C12-CF312*S12;
CF311 = -trq[3][11]+CF213*S12+CF312*C12-FA111*l[2][11]-FF112*dpt[2][12];
FB111_1 = m[11]*AM111_1;
FB211_1 = m[11]*AM211_1;
FB311_1 = m[11]*C10;
FM111_1 = FB111_1+FM112_1;
FM211_1 = FB211_1+FM213_1*C12-FM312_1*S12;
FM311_1 = FB311_1+FM213_1*S12+FM312_1*C12;
CM111_1 = CM112_1+FB311_1*l[2][11]+dpt[2][12]*(FM213_1*S12+FM312_1*C12);
CM211_1 = CM213_1*C12-CM312_1*S12;
CM311_1 = CM213_1*S12+CM312_1*C12-FB111_1*l[2][11]-FM112_1*dpt[2][12];
FB311_10 = m[11]*l[2][11]*C11;
CM111_10 = CM112_10+FB311_10*l[2][11]+dpt[2][12]*(FM213_10*S12+FM312_10*C12);
CM211_10 = CM213_10*C12-CM312_10*S12;
CM311_10 = CM213_10*S12+CM312_10*C12-FM112_10*dpt[2][12];
FB111_11 = -m[11]*l[2][11];
CM311_11 = CM213_11*S12+CM312_11*C12-FB111_11*l[2][11]-FM112_11*dpt[2][12];
FF210 = FF111*S11+FF211*C11;
CF110 = CF111*C11-CF211*S11;
FM210_1 = FM111_1*S11+FM211_1*C11;
CM110_1 = CM111_1*C11-CM211_1*S11;
CM110_10 = CM111_10*C11-CM211_10*S11;
FA19 = -frc[1][9]+m[9]*(AF19+BS29*l[2][9]);
FA29 = -frc[2][9]+m[9]*(AF29+BS59*l[2][9]);
FA39 = -frc[3][9]+m[9]*(AF38+BEF89*l[2][9]);
CF19 = -trq[1][9]+FA39*l[2][9];
CF39 = -trq[3][9]-FA19*l[2][9];
FB19_1 = m[9]*AM19_1;
FB29_1 = m[9]*AM29_1;
FB39_1 = m[9]*C8;
CM19_1 = FB39_1*l[2][9];
CM39_1 = -FB19_1*l[2][9];
FB39_8 = m[9]*l[2][9]*C9;
CM19_8 = FB39_8*l[2][9];
FB19_9 = -m[9]*l[2][9];
CM39_9 = -FB19_9*l[2][9];
FF28 = FA19*S9+FA29*C9;
CF18 = trq[2][9]*S9+CF19*C9;
FM28_1 = FB19_1*S9+FB29_1*C9;
CM18_1 = CM19_1*C9;
CM18_8 = CM19_8*C9;
FA17 = -frc[1][7]+m[7]*(AF17+BS27*l[2][7]);
FA27 = -frc[2][7]+m[7]*(AF27+BS57*l[2][7]);
FA37 = -frc[3][7]+m[7]*(AF36+BEF87*l[2][7]);
CF17 = -trq[1][7]+FA37*l[2][7];
CF37 = -trq[3][7]-FA17*l[2][7];
FB17_1 = m[7]*AM17_1;
FB27_1 = m[7]*AM27_1;
FB37_1 = m[7]*C6;
CM17_1 = FB37_1*l[2][7];
CM37_1 = -FB17_1*l[2][7];
FB37_6 = m[7]*l[2][7]*C7;
CM17_6 = FB37_6*l[2][7];
FB17_7 = -m[7]*l[2][7];
CM37_7 = -FB17_7*l[2][7];
FF26 = FA17*S7+FA27*C7;
CF16 = trq[2][7]*S7+CF17*C7;
FM26_1 = FB17_1*S7+FB27_1*C7;
CM16_1 = CM17_1*C7;
CM16_6 = CM17_6*C7;
FA15 = -frc[1][5]+m[5]*(AF15+BS25*l[2][5]);
FA25 = -frc[2][5]+m[5]*(AF25+BS55*l[2][5]);
FA35 = -frc[3][5]+m[5]*(AF34+BEF85*l[2][5]);
CF15 = -trq[1][5]+FA35*l[2][5];
CF35 = -trq[3][5]-FA15*l[2][5];
FB15_1 = m[5]*AM15_1;
FB25_1 = m[5]*AM25_1;
FB35_1 = m[5]*C4;
CM15_1 = FB35_1*l[2][5];
CM35_1 = -FB15_1*l[2][5];
FB35_4 = m[5]*l[2][5]*C5;
CM15_4 = FB35_4*l[2][5];
FB15_5 = -m[5]*l[2][5];
CM35_5 = -FB15_5*l[2][5];
FF24 = FA15*S5+FA25*C5;
CF14 = trq[2][5]*S5+CF15*C5;
FM24_1 = FB15_1*S5+FB25_1*C5;
CM14_1 = CM15_1*C5;
CM14_4 = CM15_4*C5;
FA13 = -frc[1][3]+m[3]*(AF13+BS23*l[2][3]);
FA23 = -frc[2][3]+m[3]*(AF23+BS53*l[2][3]);
FA33 = -frc[3][3]+m[3]*(AF32+BEF83*l[2][3]);
CF13 = -trq[1][3]+FA33*l[2][3];
CF33 = -trq[3][3]-FA13*l[2][3];
FB13_1 = m[3]*AM13_1;
FB23_1 = m[3]*AM23_1;
FB33_1 = m[3]*C2;
CM13_1 = FB33_1*l[2][3];
CM33_1 = -FB13_1*l[2][3];
FB33_2 = m[3]*l[2][3]*C3;
CM13_2 = FB33_2*l[2][3];
FB13_3 = -m[3]*l[2][3];
CM33_3 = -FB13_3*l[2][3];
FF22 = FA13*S3+FA23*C3;
CF12 = trq[2][3]*S3+CF13*C3;
FM22_1 = FB13_1*S3+FB23_1*C3;
CM12_1 = CM13_1*C3;
CM12_2 = CM13_2*C3;
FA31 = -frc[3][1]-m[1]*g[3];
FF31 = FA31+FA33*C2+FA35*C4+FA37*C6+FA39*C8+FF210*S10+FF22*S2+FF24*S4+FF26*S6+FF28*S8+FF311*C10;
FM31_1 = m[1]+FB33_1*C2+FB35_1*C4+FB37_1*C6+FB39_1*C8+FM210_1*S10+FM22_1*S2+FM24_1*S4+FM26_1*S6+FM28_1*S8+FM311_1*C10;
 
// Symbolic model output

c[1] = FF31;
c[2] = CF12;
c[3] = CF33;
c[4] = CF14;
c[5] = CF35;
c[6] = CF16;
c[7] = CF37;
c[8] = CF18;
c[9] = CF39;
c[10] = CF110;
c[11] = CF311;
c[12] = CF112;
c[13] = CF213;
c[14] = CF314;
c[15] = CF215;
c[16] = -frc[3][16];
M[1][1] = FM31_1;
M[1][2] = CM12_1;
M[1][3] = CM33_1;
M[1][4] = CM14_1;
M[1][5] = CM35_1;
M[1][6] = CM16_1;
M[1][7] = CM37_1;
M[1][8] = CM18_1;
M[1][9] = CM39_1;
M[1][10] = CM110_1;
M[1][11] = CM311_1;
M[1][12] = CM112_1;
M[1][13] = CM213_1;
M[1][14] = CM314_1;
M[2][1] = CM12_1;
M[2][2] = CM12_2;
M[3][1] = CM33_1;
M[3][3] = CM33_3;
M[4][1] = CM14_1;
M[4][4] = CM14_4;
M[5][1] = CM35_1;
M[5][5] = CM35_5;
M[6][1] = CM16_1;
M[6][6] = CM16_6;
M[7][1] = CM37_1;
M[7][7] = CM37_7;
M[8][1] = CM18_1;
M[8][8] = CM18_8;
M[9][1] = CM39_1;
M[9][9] = CM39_9;
M[10][1] = CM110_1;
M[10][10] = CM110_10;
M[10][11] = CM311_10;
M[10][12] = CM112_10;
M[10][13] = CM213_10;
M[10][14] = CM314_10;
M[10][15] = CM215_10;
M[11][1] = CM311_1;
M[11][10] = CM311_10;
M[11][11] = CM311_11;
M[11][12] = CM112_11;
M[11][13] = CM213_11;
M[11][14] = CM314_11;
M[11][15] = CM215_11;
M[12][1] = CM112_1;
M[12][10] = CM112_10;
M[12][11] = CM112_11;
M[12][12] = CM112_12;
M[12][13] = CM213_12;
M[12][14] = CM314_12;
M[12][15] = CM215_12;
M[13][1] = CM213_1;
M[13][10] = CM213_10;
M[13][11] = CM213_11;
M[13][12] = CM213_12;
M[13][13] = CM213_13;
M[13][14] = CM314_13;
M[13][15] = CM215_13;
M[14][1] = CM314_1;
M[14][10] = CM314_10;
M[14][11] = CM314_11;
M[14][12] = CM314_12;
M[14][13] = CM314_13;
M[14][14] = CM314_14;
M[15][10] = CM215_10;
M[15][11] = CM215_11;
M[15][12] = CM215_12;
M[15][13] = CM215_13;
M[15][15] = In[5][15];

// Number of continuation lines = 2

}
